% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slot-methods.R
\name{slot-methods}
\alias{slot-methods}
\alias{experimentData,MultimodalExperiment-method}
\alias{experimentData}
\alias{experimentData<-,MultimodalExperiment-method}
\alias{experimentData<-}
\alias{subjectData,MultimodalExperiment-method}
\alias{subjectData}
\alias{subjectData<-,MultimodalExperiment-method}
\alias{subjectData<-}
\alias{sampleData,MultimodalExperiment-method}
\alias{sampleData}
\alias{sampleData<-,MultimodalExperiment-method}
\alias{sampleData<-}
\alias{cellData,MultimodalExperiment-method}
\alias{cellData}
\alias{cellData<-,MultimodalExperiment-method}
\alias{cellData<-}
\alias{experimentMap,MultimodalExperiment-method}
\alias{experimentMap}
\alias{experimentMap<-,MultimodalExperiment-method}
\alias{experimentMap<-}
\alias{subjectMap,MultimodalExperiment-method}
\alias{subjectMap}
\alias{subjectMap<-,MultimodalExperiment-method}
\alias{subjectMap<-}
\alias{sampleMap,MultimodalExperiment-method}
\alias{sampleMap}
\alias{sampleMap<-,MultimodalExperiment-method}
\alias{sampleMap<-}
\alias{cellMap,MultimodalExperiment-method}
\alias{cellMap}
\alias{cellMap<-,MultimodalExperiment-method}
\alias{cellMap<-}
\alias{experiments,MultimodalExperiment-method}
\alias{experiments}
\alias{experiments<-,MultimodalExperiment-method}
\alias{experiments<-}
\title{MultimodalExperiment Slot Methods}
\usage{
\S4method{experimentData}{MultimodalExperiment}(object)

\S4method{experimentData}{MultimodalExperiment}(object) <- value

\S4method{subjectData}{MultimodalExperiment}(object)

\S4method{subjectData}{MultimodalExperiment}(object) <- value

\S4method{sampleData}{MultimodalExperiment}(object)

\S4method{sampleData}{MultimodalExperiment}(object) <- value

\S4method{cellData}{MultimodalExperiment}(object)

\S4method{cellData}{MultimodalExperiment}(object) <- value

\S4method{experimentMap}{MultimodalExperiment}(object)

\S4method{experimentMap}{MultimodalExperiment}(object) <- value

\S4method{subjectMap}{MultimodalExperiment}(object)

\S4method{subjectMap}{MultimodalExperiment}(object) <- value

\S4method{sampleMap}{MultimodalExperiment}(object)

\S4method{sampleMap}{MultimodalExperiment}(object) <- value

\S4method{cellMap}{MultimodalExperiment}(object)

\S4method{cellMap}{MultimodalExperiment}(object) <- value

\S4method{experiments}{MultimodalExperiment}(object)

\S4method{experiments}{MultimodalExperiment}(object) <- value
}
\arguments{
\item{object}{a \linkS4class{MultimodalExperiment} object}

\item{value}{a replacement value}
}
\value{
Extract methods return the value of the slot.
}
\description{
Extract or replace slots of a \linkS4class{MultimodalExperiment} object.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

experimentData(ME)

subjectData(ME)

sampleData(ME)

cellData(ME)

experimentMap(ME)

subjectMap(ME)

sampleMap(ME)

cellMap(ME)

experiments(ME)

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
