% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-methods.R
\name{annotation-methods}
\alias{annotation-methods}
\alias{joinAnnotations,MultimodalExperiment-method}
\alias{joinAnnotations}
\title{MultimodalExperiment Annotation Methods}
\usage{
\S4method{joinAnnotations}{MultimodalExperiment}(x)
}
\arguments{
\item{x}{a \linkS4class{MultimodalExperiment} object}
}
\value{
\code{joinAnnotations} returns a \link[S4Vectors:DataFrame-class]{DataFrame}
object.
}
\description{
\code{joinAnnotations} joins all annotations into an unnormalized
\link[S4Vectors:DataFrame-class]{DataFrame} object.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

joinAnnotations(ME)

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
