% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiBaC.R
\docType{package}
\name{MultiBaC}
\alias{MultiBaC}
\alias{MultiBaC-package}
\title{MultiBaC}
\usage{
MultiBaC(mbac, test.comp = NULL, scale = FALSE, center = TRUE,
  showplot = TRUE, crossval = NULL, Interaction = FALSE,
  Variability = 0.9, showinfo = TRUE)
}
\arguments{
\item{mbac}{mbac object generated by createMbac.}

\item{test.comp}{Maximum number of components allowed for PLS models. If NULL (default), the minimal effective rank of the matrices is used as the maximum number of components.}

\item{scale}{Logical. Whether X and Y matrices must be scaled. By default, FALSE.}

\item{center}{Logical. Whether X and Y matrices must be centered. By default, TRUE.}

\item{showplot}{Logical. If TRUE (default), the Q2 and the explained variance plots are shown.}

\item{crossval}{Integer: number of cross-validation segments. The number of samples (rows of 'x') must be at least >= crossvalI. If NULL (default), a leave-one-out crossvalidation is performed.}

\item{Interaction}{Logical. Whether to model the interaction between experimental factors and bacth factor in ARSyN models. By default, FALSE.}

\item{Variability}{From 0 to 1. Minimum percent of data variability that must be explained by each ARSyN model. By default, 0.90.}

\item{showinfo}{Logical. If TRUE (default), the information about the function progress is shown.}
}
\value{
Custom mbac object. Elements in a mbac object:
\enumerate{
    \item ListOfBatches: A list of MultiAssayExperiment objects (one per batch).
    \item commonOmic: Name of the common omic between the batches.
    \item CorrectedData: Same structure than ListOfBatches but with the corrected data instead of the original.
    \item PLSmodels: PLS models created during MultiBaC method performance (one model per non-common omic data type).
    \item ARSyNmodels: ARSyN models created during MultiBaC performance (one per omic data type).
    \item InnerRelation: Table of class data.frame containing the inner correlation (i.e. correlation between the scores of X (t) and Y (u) matrices) for each PLS model across all components.
}
}
\description{
MultiBaC performs a multi-omic, multi-batch correction

MultiBaC is a strategy to correct batch effects from multiomic datasets distributed across different labs or data acquisition events.
MultiBaC is the first Batch effect correction algorithm that dealing with batch effect correction in multiomics datasets.
MultiBaC is able to remove batch effects across different omics generated within separate batches provided that at least one common
omic data type is included in all the batches considered.
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"),
                       commonOmic = "RNA")

my_final_mbac <- MultiBaC (my_mbac,
                           test.comp = NULL, scale = FALSE,
                           center = TRUE, crossval = NULL,
                           Variability = 0.90,
                           Interaction = TRUE ,
                           showplot = FALSE,
                           showinfo = FALSE)

}
\references{
Ugidos, M., Tarazona, S., Prats-Montalbán, J. M., Ferrer, A., & Conesa, A. (2020). MultiBaC: A strategy to remove batch effects between different omic data types. Statistical Methods in Medical Research. https://doi.org/10.1177/0962280220907365
}
