% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping-functions.R
\name{groupClosest}
\alias{groupClosest}
\title{Group values with differences below threshold}
\usage{
groupClosest(x, maxDiff = 1, FUN = groupSimilarityMatrix, ...)
}
\arguments{
\item{x}{\code{numeric} of values that should be grouped.}

\item{maxDiff}{\code{numeric(1)} defining the threshold for difference between
values in \code{x} to be grouped into the same group.}

\item{FUN}{supported similarity calculation function. Can be either
\link{groupSimilarityMatrix} (the default) or \link{groupSimilarityMatrixTree},
the latter being faster and less memory demanding.}

\item{...}{additional parameters passed to \code{FUN}.}
}
\value{
\code{integer} with the group assignment (values grouped together have
the same return value).
}
\description{
Group values with a difference between them being smaller than a user
defined threshold. This function uses the \code{\link[=groupSimilarityMatrix]{groupSimilarityMatrix()}} or the
\code{\link[=groupSimilarityMatrixTree]{groupSimilarityMatrixTree()}} function to create groups with smallest
differences between its members. Differences between \strong{all} members of
one group are below the user defined threshold \code{maxDiff}. This is a more
stringent grouping than what \code{\link[=groupConsecutive]{groupConsecutive()}} performs leading thus to
smaller groups (with smaller differences between its members).
}
\examples{

x <- c(1.1, 1.9, 2.2)
groupClosest(x)
## Although the difference between the 1st and 2nd element would be smaller
## than the threshold, they are not grouped because the difference between
## the 2nd and 3rd element is even smaller. The first element is also not
## put into the same group, because it has a difference > diffRt to the 3rd
## element.

x <- c(1.1, 1.5, 1.7, 2.3, 2.7, 4.3, 4.4, 4.9, 5.2, 5.4, 5.8, 6, 7,
    9, 9.5, 15)

groupClosest(x)
}
\seealso{
Other grouping operations: 
\code{\link{groupConsecutive}()},
\code{\link{groupSimilarityMatrix}()},
\code{\link{groupSimilarityMatrixTree}()}
}
\author{
Johannes Rainer, Johan Lassen
}
\concept{grouping operations}
