% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/featureGroups.R
\name{featureGroups}
\alias{featureGroups}
\alias{featureGroups<-,SummarizedExperiment-method}
\alias{featureGroups,SummarizedExperiment-method}
\alias{featureGroups<-}
\title{Get or set feature group definitions from an object}
\usage{
featureGroups(object, ...)

featureGroups(object) <- value

\S4method{featureGroups}{SummarizedExperiment}(object)

\S4method{featureGroups}{SummarizedExperiment}(object) <- value
}
\arguments{
\item{object}{the input object. In the \code{MsFeatures} package this method is
implemented for \code{SummarizedExperiment}.}

\item{...}{ignored.}

\item{value}{the new value for the \emph{feature groups} variable.}
}
\value{
a \code{character} with the group assignment of the features. Has to have
the same length as there are features in \code{object.}
}
\description{
\code{featureGroups} and \verb{featureGroups<-} allow to extract or set the feature
definitions from the input object. The implementations for
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment()}} get or set the content of
a column named \code{"feature_group"} in the object's \code{rowData}.

This method should be implemented for all other object for which a
\code{\link[=groupFeatures]{groupFeatures()}} method is defined.
}
\examples{

## Load the test SummarizedExperiment
library(SummarizedExperiment)
data(se)

## No column "feature_group" present in the object, this NA is returned
featureGroups(se)

## Add a column "feature_group" to the `rowData` of the object
rowData(se)$feature_group <- seq_len(nrow(rowData(se)))

featureGroups(se)
}
\author{
Johannes Rainer
}
