% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crap.R
\name{cRAP}
\alias{cRAP}
\alias{crap}
\alias{contaminatants}
\alias{crap_ccp.fasta}
\alias{crap_gpm.fasta}
\alias{crap_maxquant.fasta.gz}
\title{Contaminant and cRAP databases}
\description{
These 3 fasta files are widely used proteomics contaminants. The files are:
\enumerate{
\item crap_gpm.fasta: the common Repository of Adventitious Proteins (cRAP)
from the Global Proteome Machine (GPM) organisation.
\item crap_ccp.fasta: Cambridge Centre for Proteomics' own cRAP fasta database.
\item crap_maxquant.fasta.gz: MaxQuant's contaminant database.
}

These files are extracted from the \code{camprotR} package and described in the
cRAP databases vignette (see References).

These files are added to the \code{MsDataHub} package via the corresponding
Zenodo repository to raciliate re-use with minimal dependecies and avoid
repeated downloaded using caching.

All credit for compiling the fasta files goes to Charlotte Dawson,
maintainer of the \code{camprotR} package.
}
\references{
\itemize{
\item cRAP databases vignette: https://cambridgecentreforproteomics.github.io/camprotR/articles/crap.html
\item cRPA protein sequences (GPM): https://www.thegpm.org/crap/
\item camprotR package: https://cambridgecentreforproteomics.github.io/camprotR/index.html
\item Gatto, L. (2025). Proteomics contaminant databases
(1.0). Zenodo. https://doi.org/10.5281/zenodo.15115102
}
}
\author{
Laurent Gatto
}
