% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{isPeaksMatrix}
\alias{isPeaksMatrix}
\title{Check functions}
\usage{
isPeaksMatrix(x)
}
\arguments{
\item{x}{object to test.}
}
\value{
\code{logical(1)}, \code{TRUE} if checks are successful otherwise \code{FALSE}.
}
\description{
These functions are used to check input arguments.
}
\details{
\code{isPeaksMatrix}: test for a \code{numeric} matrix with two columns named "mz" and
"intensity". The "mz" column has to be sorted increasingly.
}
\examples{
isPeaksMatrix(1:2)
isPeaksMatrix(cbind(mz = 2:1, intensity = 1:2))
isPeaksMatrix(cbind(mz = 1:2, intensity = 1:2))
}
\seealso{
Other helper functions for developers: 
\code{\link{between}()},
\code{\link{rbindFill}()},
\code{\link{validPeaksMatrix}()},
\code{\link{vapply1c}()},
\code{\link{which.first}()}
}
\author{
Sebastian Gibb
}
\concept{helper functions for developers}
