% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_query.R
\name{finemap_query}
\alias{finemap_query}
\title{Finemap query builder}
\usage{
finemap_query(
  chr,
  start = NULL,
  end = NULL,
  strain1 = NULL,
  strain2 = NULL,
  consequence = NULL,
  impact = NULL,
  thr1 = 0,
  thr2 = 0
)
}
\arguments{
\item{chr}{Vector of chromosome names.}

\item{start}{Optional vector of chromosomal start positions of target regions
(GRCm38).}

\item{end}{Optional vector of chromosomal end positions of target regions
(GRCm38).}

\item{strain1}{First strain set with strains from avail_strains().}

\item{strain2}{Second strain set with strains from avail_strains().}

\item{consequence}{Optional vector of consequence types.}

\item{impact}{Optional vector of impact types.}

\item{thr1}{Number discordant strains in strain1. Between 0 and
length(strain1)-1. 0 by default.}

\item{thr2}{Number discordant strains in strain2. Between 0 and
length(strain2)-1. 0 by default.}
}
\value{
Query string.
}
\description{
Finemap query builder
}
\keyword{internal}
