% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_button.R
\name{download_button}
\alias{download_button}
\title{Create a download button}
\usage{
download_button(
  path,
  type,
  button_label,
  output_name = NULL,
  button_type = "success",
  has_icon = TRUE,
  icon = "fa fa-save",
  add_button = TRUE,
  ...
)
}
\arguments{
\item{path}{A character string specifying the path to the file or directory.}

\item{type}{A character string specifying the type of download. Either
\code{"file"} or \code{"dir"}.}

\item{button_label}{Character (HTML), button label}

\item{output_name}{Name of of the output file. If not specified, it will take
the source file's name if one file is specified. In case of multiple files,
the \code{output_name} must be specified.}

\item{button_type}{Character, one of the standard Bootstrap types}

\item{has_icon}{Specify whether to include fontawesome icons in the button
label}

\item{icon}{Fontawesome tag e.g.: "fa fa-save"}

\item{add_button}{A logical indicating whether to add the download button to
the HTML report. (default = TRUE)}

\item{...}{
  Arguments passed on to \code{\link[downloadthis:download_file]{downloadthis::download_file}}
  \describe{
    \item{\code{self_contained}}{A boolean to specify whether your HTML output is
self-contained. Default to \code{FALSE}.}
  }}
}
\value{
\code{htmltools::\link[htmltools]{tag}}, \code{<button>}
}
\description{
Creates a download button for a file or directory, suitable to embed into
an HTML report.
}
\seealso{
\code{\link[downloadthis]{download_file}}
}
\keyword{internal}
