% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{DetectBindingSitesBed}
\alias{DetectBindingSitesBed}
\title{Detect binding sites from bed motif input}
\usage{
DetectBindingSitesBed(
  BedFile,
  IPfiles,
  BackgroundFiles,
  genome,
  genomeBuild,
  DB = "UCSC",
  fdrValue = 0.05,
  expName = "Motif_Centric_Peaks",
  windowSize = 100,
  format = ""
)
}
\arguments{
\item{BedFile}{Motif locations in bed format file}

\item{IPfiles}{IP ChIP-seq alignment files}

\item{BackgroundFiles}{Background ChIP-seq alignment files. Can be Input
experimetn, DNA whole exctract, etc.}

\item{genome}{The genome name such as "Hsapiens", "Mmusculus",
"Dmelanogaster"}

\item{genomeBuild}{The genome build such as "hg38", "hg19", "mm10", "dm3"}

\item{DB}{The database of genome build. default: "UCSC"}

\item{fdrValue}{FDR value cut-off}

\item{expName}{The name of the output table}

\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}

\item{format}{alignment format and should be one of these: "BAMPE", "BAMSE",
"BEDPE", "BEDSE"}
}
\value{
peakCallingStatistics A list FRiPs, sequence statistics, and Motif
 statistics
}
\description{
Takes user provied bed regions, and check for validity of them.
 Read bam or bed alignment files and convert to 1 nt bed and call detect
  binding site from 1nt bed.
}
\examples{

# FUR candidate motifs in NC_000913 E. coli
FurMotifs=system.file("extdata", "FurMotifs.bed", package="Motif2Site")

# ChIP-seq datasets in bed single end format
IPFe <- c(system.file("extdata", "FUR_fe1.bed", package="Motif2Site"),
        system.file("extdata", "FUR_fe2.bed", package="Motif2Site"))
Inputs <- c(system.file("extdata", "Input1.bed", package="Motif2Site"),
            system.file("extdata", "Input2.bed", package="Motif2Site"))
FURfeBedInputStats <- 
  DetectBindingSitesBed(BedFile=FurMotifs,
                        IPfiles=IPFe, 
                        BackgroundFiles=Inputs, 
                        genome="Ecoli",
                        genomeBuild="20080805",
                        DB="NCBI",
                        expName="FUR_Fe_BedInput",
                        format="BEDSE"
                       )


}
\seealso{
\code{\link{DetectBindingSitesMotif}}
}
