% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMoonlightMet.R
\name{plotMoonlightMet}
\alias{plotMoonlightMet}
\title{plotMoonlightMet
This function visualizes the effect of genes on biological processes
and total number of hypo/hyper/dual methylated CpG sites in genes.}
\usage{
plotMoonlightMet(
  DEG_Methylation_Annotations,
  Oncogenic_mediators_methylation_summary,
  dataURA,
  genes,
  additionalFilename = ""
)
}
\arguments{
\item{DEG_Methylation_Annotations}{A tibble which is outputted
from the GMA function.}

\item{Oncogenic_mediators_methylation_summary}{A tibble which
is outputted from the GMA function.}

\item{dataURA}{Output of the URA function: a table containing
the effect of oncogenic mediators on biological processes. This
effect is quantified through Moonlight Gene Z-scores.}

\item{genes}{A character string containing the genes to be
visualized.}

\item{additionalFilename}{A character string that can be used
to add a prefix or filepath to the filename of the pdf
visualizing the heatmap. Default is an empty string.}
}
\value{
No value is returned. Visualization in form of a heatmap
is saved.
}
\description{
plotMoonlightMet
This function visualizes the effect of genes on biological processes
and total number of hypo/hyper/dual methylated CpG sites in genes.
}
\examples{
data("DEG_Methylation_Annotations")
data("Oncogenic_mediators_methylation_summary")
data("dataURA_plot")
genes <- c("ACAN", "ACE2", "ADAM19", "AFAP1L1")
plotMoonlightMet(DEG_Methylation_Annotations = DEG_Methylation_Annotations,
                 Oncogenic_mediators_methylation_summary = Oncogenic_mediators_methylation_summary,
                 dataURA = dataURA_plot,
                 genes = genes,
                 additionalFilename = "./GMAresults/")
}
