% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-ModStringSet-io.R
\name{ModStringSet-io}
\alias{ModStringSet-io}
\alias{readModDNAStringSet}
\alias{readModRNAStringSet}
\alias{writeModStringSet}
\title{Read/write an ModStringSet object from/to a file}
\usage{
readModDNAStringSet(
  filepath,
  format = "fasta",
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE,
  with.qualities = FALSE
)

readModRNAStringSet(
  filepath,
  format = "fasta",
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE,
  with.qualities = FALSE
)

writeModStringSet(
  x,
  filepath,
  append = FALSE,
  compress = FALSE,
  compression_level = NA,
  format = "fasta",
  ...
)
}
\arguments{
\item{filepath, format, nrec, skip, seek.first.rec, use.names, with.qualities, append, compress, compression_level, ...}{See \code{\link[Biostrings:XStringSet-io]{XStringSet-io}} for more details.}

\item{x}{A \code{ModStringSet} object.}
}
\value{
A \code{\link{ModStringSet}} of the defined type.
}
\description{
Functions to read/write an ModStringSet object from/to a file.
}
\examples{
seqs <- paste0(paste(alphabet(ModDNAString()), collapse = ""),
               c("A","G","T"))
seqs

set <- ModDNAStringSet(seqs)
set

file <- tempfile()
writeModStringSet(set, file)
read <- readModDNAStringSet(file)
read
}
