% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_adonis_anosim.R
\name{mp_mrpp}
\alias{mp_mrpp}
\alias{mp_mrpp,MPSE-method}
\alias{mp_mrpp,MPSE}
\alias{mp_mrpp,tbl_mpse-method}
\alias{mp_mrpp,tbl_mpse}
\alias{mp_mrpp,grouped_df_mpse-method}
\alias{mp_mrpp,grouped_df_mpse}
\title{Analysis of Multi Response Permutation Procedure (MRPP) with MPSE or tbl_mpse object}
\usage{
mp_mrpp(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_mrpp}{MPSE}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_mrpp}{tbl_mpse}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_mrpp}{grouped_df_mpse}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.group}{The name of the column of the sample group information.}

\item{distmethod}{character the method to calculate pairwise distances,
default is 'bray'.}

\item{action}{character "add" joins the ANOSIM result to internal attribute of
the object, "only" return a tibble contained the statistic information of MRPP 
analysis, and "get" return 'mrpp' object can be analyzed using the related vegan 
funtion.}

\item{permutations}{the number of permutations required, default is 999.}

\item{seed}{a random seed to make the MRPP analysis reproducible, default is 123.}

\item{...}{additional parameters see also 'mrpp' of vegan.}
}
\value{
update object according action argument
}
\description{
Analysis of Multi Response Permutation Procedure (MRPP) with MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\%
  mp_decostand(.abundance=Abundance) \%>\% 
  mp_mrpp(.abundance=hellinger, 
          .group=time, 
          distmethod="bray", 
          permutations=999, # for more robust, set it to 9999. 
          action="get")
}
\author{
Shuangbin
}
