% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_upset.R
\name{get_upset}
\alias{get_upset}
\alias{get_upset,data.frame-method}
\alias{get_upset,data.frame}
\alias{get_upset,phyloseq-method}
\alias{get_upset,phyloseq}
\title{generate the dataset for upset of UpSetR}
\usage{
get_upset(obj, ...)

\S4method{get_upset}{data.frame}(obj, sampleda, factorNames, threshold = 0)

\S4method{get_upset}{phyloseq}(obj, ...)
}
\arguments{
\item{obj}{object, phyloseq or data.frame, if it is data.frame, 
the shape of it should be row sample * columns features.}

\item{..., }{additional parameters.}

\item{sampleda}{data.frame, if the obj is data.frame, the sampleda
should be provided.}

\item{factorNames}{character, the column names of factor in sampleda}

\item{threshold}{integer, default is 0.}
}
\value{
a data.frame for the input of `upset` of `UpSetR`.
}
\description{
generate the dataset for upset of UpSetR
}
\examples{
\dontrun{
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
upsetda <- get_upset(test_otu_data, factorNames="group")
otudafile <- system.file("extdata", "otu_tax_table.txt",
                         package="MicrobiotaProcess")
samplefile <- system.file("extdata","sample_info.txt", 
                         package="MicrobiotaProcess")
otuda <- read.table(otudafile, sep="\t", header=TRUE, 
                    row.names=1, check.names=FALSE,
                    skip=1, comment.char="")
sampleda <- read.table(samplefile,sep="\t", 
                       header=TRUE, row.names=1)
head(sampleda)
otuda <- otuda[sapply(otuda, is.numeric)]
otuda <- data.frame(t(otuda), check.names=FALSE)
head(otuda[1:5, 1:5])
upsetda2 <- get_upset(obj=otuda, sampleda=sampleda, 
                     factorNames="group")
#Then you can use `upset` of `UpSetR` to visualize the results.
library(UpSetR)
upset(upsetda, sets=c("B","D","M","N"), sets.bar.color = "#56B4E9",
      order.by = "freq", empty.intersections = "on")
}
}
\author{
Shuangbin Xu
}
