% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_residuals.R
\name{get_residuals}
\alias{get_residuals}
\title{Get residuals from regression model}
\usage{
get_residuals(data, metadata.samples = NULL, metadata.genes = NULL, cores = 1)
}
\arguments{
\item{data}{A matrix or SummarizedExperiment object
with samples as columns and features (gene, probes)
as rows. Note that expression values should typically be log2(expx + 1)
transformed before fitting linear regression models.}

\item{metadata.samples}{A data frame with samples as rows and columns the covariates.
No NA values are allowed, otherwise residual of the corresponding sample will be NA.}

\item{metadata.genes}{A data frame with genes (covariates) as rows and samples as columns.
For each evaluated gene, each column (e.g. CNA) that corresponds to the same gene
will be set as a single covariate variable. This can be used to correct copy number alterations for each gene.}

\item{cores}{Number of CPU cores to be used. Defaults to 1.}
}
\value{
A residuals matrix with samples as columns and features (gene, probes) as rows
}
\description{
Compute studentized residuals from fitting linear regression models to expression values
in a data matrix
}
\details{
When only \code{metadata.samples} are provided, this function computes
residuals for expression values in a data matrix by fitting model

\code{features ~ Sample_covariate1 + Sample_covariate2 ... + Sample_covariateN}
where \code{N} is the index of the columns in the metadata provided, \code{features} are
(typically log transformed) expression values.

When the user additionally provide \code{metadata.genes},
that is, gene metadata (e.g. gene_covariate = copy number variations/alterations)
residuals are computed by fitting the following model:

\code{features ~ Sample_covariate1 + Sample_covariate2 ... + Sample_covariateN + gene_covariate}
}
\examples{
data("gene.exp.chr21.log2")

data("clinical")
metadata <- clinical[,c( "gender", "sample_type")]

cnv <- matrix(
   sample(x = c(-2,-1,0,1,2),
   size = ncol(gene.exp.chr21.log2) * nrow(gene.exp.chr21.log2),replace = TRUE),
   nrow = nrow(gene.exp.chr21.log2),
   ncol = ncol(gene.exp.chr21.log2)
)
rownames(cnv) <- rownames(gene.exp.chr21.log2)
colnames(cnv) <- colnames(gene.exp.chr21.log2)

gene.exp.residuals <- get_residuals(
   data = gene.exp.chr21.log2[1:3,],
   metadata.samples = metadata,
   metadata.genes = cnv
)
gene.exp.residuals <- get_residuals(
   data = gene.exp.chr21.log2[1:3,],
   metadata.samples = metadata,
   metadata.genes = cnv[1:2,]
)
gene.exp.residuals <- get_residuals(
   data = gene.exp.chr21.log2[1:3,],
   metadata.samples = metadata
)
}
