% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_quantile.R
\name{filter_dnam_by_quant_diff}
\alias{filter_dnam_by_quant_diff}
\title{Select regions with variations in DNA methylation
levels above a threshold}
\usage{
filter_dnam_by_quant_diff(dnam, min.IQR.threshold = 0.2, cores = 1)
}
\arguments{
\item{dnam}{DNA methylation matrix or SummarizedExperiment object}

\item{min.IQR.threshold}{Threshold for minimal interquantile range (difference between the 75th and 25th percentiles)
of the DNAm}

\item{cores}{Number of CPU cores to be used in the analysis. Default: 1}
}
\value{
A subset of the original matrix only with the
rows passing the filter threshold.
}
\description{
For each region, computes the interquartile range (IQR) of the DNA methylation (DNAm) 
levels and requires the IQR to be above a threshold
}
\examples{
data("dna.met.chr21")
dna.met.chr21.filtered <- filter_dnam_by_quant_diff(
  dna.met.chr21
)
}
