% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{matchSpectra}
\alias{matchSpectra}
\title{Spectral matching}
\usage{
matchSpectra(query, target, param, ...)
}
\arguments{
\item{query}{\link[Spectra:Spectra]{Spectra::Spectra} object with the (experimental) spectra.}

\item{target}{MS data to compare against. Can be another \link[Spectra:Spectra]{Spectra::Spectra}.}

\item{param}{parameter object containing the settings for the matching (e.g.
eventual prefiltering settings, cut-off value for similarity above which
spectra are considered matching etc).}

\item{...}{optional parameters.}
}
\value{
a \link{MatchedSpectra} object with the spectra matching results.
}
\description{
The \code{matchSpectra} method matches (compares) spectra from \code{query} with those
from \code{target} based on settings specified with \code{param} and returns the result
from this as a \link{MatchedSpectra} object.
}
\seealso{
\code{\link[=CompareSpectraParam]{CompareSpectraParam()}} for the comparison between
\link[Spectra:Spectra]{Spectra::Spectra} objects.
}
\author{
Johannes Rainer
}
