% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaNeighborUS.R
\name{MetaNeighborUS}
\alias{MetaNeighborUS}
\title{Runs unsupervised version of MetaNeighbor}
\usage{
MetaNeighborUS(
  var_genes = c(),
  dat,
  i = 1,
  study_id,
  cell_type,
  trained_model = NULL,
  fast_version = FALSE,
  node_degree_normalization = TRUE,
  one_vs_best = FALSE,
  symmetric_output = TRUE
)
}
\arguments{
\item{var_genes}{vector of high variance genes.}

\item{dat}{SummarizedExperiment object containing gene-by-sample
expression matrix.}

\item{i}{default value 1; non-zero index value of assay containing the matrix
data}

\item{study_id}{a vector that lists the Study (dataset) ID for each sample}

\item{cell_type}{a vector that lists the cell type of each sample}

\item{trained_model}{default value NULL; a matrix containing a trained model
generated from MetaNeighbor::trainModel. If not NULL, the trained model is
treated as training data and dat is treated as testing data. If a trained model
is provided, fast_version will automatically be set to TRUE and var_genes will
be overridden with genes used to generate the trained_model}

\item{fast_version}{default value FALSE; a boolean flag indicating whether
to use the fast and low memory version of MetaNeighbor}

\item{node_degree_normalization}{default value TRUE; a boolean flag indicating
whether to use normalize votes by dividing through total node degree.}

\item{one_vs_best}{default value FALSE; a boolean flag indicating whether
to compute AUROCs based on a best match against second best match setting
(default version is one-vs-rest). This option is currently only relevant
when fast_version = TRUE.}

\item{symmetric_output}{default value TRUE; a boolean flag indicating whether
to average AUROCs in the output matrix.}
}
\value{
The output is a cell type-by-cell type mean AUROC matrix, which is
built by treating each pair of cell types as testing and training data for
MetaNeighbor, then taking the average AUROC for each pair (NB scores will not
be identical because each test cell type is scored out of its own dataset,
and the differential heterogeneity of datasets will influence scores).
If symmetric_output is set to FALSE, the training cell types are displayed
as columns and the test cell types are displayed as rows.
If trained_model was provided, the output will be a cell type-by-cell
type AUROC matrix with training cell types as columns and test cell types
as rows (no swapping of test and train, no averaging).
}
\description{
When it is difficult to know how cell type labels compare across datasets this
function helps users to make an educated guess about the overlaps without
requiring in-depth knowledge of marker genes
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
celltype_NV = MetaNeighborUS(var_genes = var_genes,
                             dat = mn_data,
                             study_id = mn_data$study_id,
                             cell_type = mn_data$cell_type)
celltype_NV

}
