% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_function.R
\name{pcoa_plot_discrete}
\alias{pcoa_plot_discrete}
\title{PCoA plots for discrete variables.}
\usage{
pcoa_plot_discrete(
  X,
  covariate,
  title,
  R2 = TRUE,
  dissimilarity = "Bray-Curtis",
  colorset = "Set1",
  point_size = 1
)
}
\arguments{
\item{X}{Abundance matrix.
Rows represent taxa, and columns represent samples.}

\item{covariate}{A discrete sample covariate.}

\item{title}{The title of the graph.}

\item{R2}{A logical variable.
Whether to display the R² statistic in the subtitle. Default is \code{TRUE}.}

\item{dissimilarity}{The dissimilarity type.
Options include:
\itemize{
\item \code{"Bray-Curtis"} for Bray-Curtis dissimilarity.
\item \code{"Euclidean"} for generalized UniFrac dissimilarity.
}}

\item{colorset}{The color set for visualization. Default is \code{"Set1"}.}

\item{point_size}{The size of the points in the plot. Default is \code{1}.}
}
\value{
a PCoA plot.
}
\description{
PCoA plots for discrete variables.
}
\examples{
 data(exampleData)
 O = exampleData$O
 meta = exampleData$meta
 batchid = meta$batch
 pcoa_plot_discrete(O,batchid,"Batch")

}
