% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_function.R
\name{community_detection}
\alias{community_detection}
\title{Taxa/Sample Community detection.}
\usage{
community_detection(
  X,
  max_k = 10,
  method = "Louvain",
  resolution = 1,
  min_k = 2
)
}
\arguments{
\item{X}{Input data.
Rows represent clustering objects, and columns represent features.}

\item{max_k}{The largest number of connected neighbors.}

\item{method}{The community detection method to use. Options include \code{"Louvain"} and \code{"Walktrap"}.}

\item{resolution}{The resolution parameter for the Louvain algorithm.}

\item{min_k}{The smallest number of connected neighbors.}
}
\value{
A \code{list} with the following components:
\item{\code{cluster}}{ – The estimated cluster labels.}
\item{\code{graph}}{ – The \code{k}-nearest neighbor graph.}
}
\description{
A \code{k}-nearest neighbor graph is constructed based on Euclidean distance. Then community detection method is applied to identify communities.
Various values of \code{k} within a specific range are tried and the one that yields the highest average Silhouette score is selected.
}
\examples{
 data(exampleData)
 O = exampleData$O
 meta = exampleData$meta
 dist_mat = exampleData$dist_mat
 metadict_res = MetaDICT(O, meta, distance_matrix = dist_mat)
 D = metadict_res$D
 D_filter = D[,1:20]
 taxa_c = community_detection(D_filter, max_k = 5)

}
