% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set2Frame.R
\name{set2Frame}
\alias{set2Frame}
\title{Combine cells in a flow set into a flow frame.}
\usage{
set2Frame(flowSet)
}
\arguments{
\item{flowSet}{A flow set object}
}
\value{
Returns a flowFrame object. All cells from flow set are combined into
  one flow frame. A new parameter, sample_id, is introduced to indicate the
  origin of each cell.
}
\description{
A function that combines cells in a flow set into a flow frame.
}
\examples{
library(flowCore)
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                  package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
flow_set = read.flowSet(files)
flow_frame = set2Frame(flow_set)
}
