% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz_summary.R
\name{mz_vis}
\alias{mz_vis}
\title{Visualize mass difference distribution}
\usage{
mz_vis(df, var = "group")
}
\arguments{
\item{df}{`data.frame`, previously generated by `mz_summary`. Needs to contain
the columns "transformation", "mass_difference" and "counts".}

\item{var}{`character(1)`, the column in `df` to visualize on the y-axis}
}
\value{
`ggplot` object and corresponding barplot for visualizations
}
\description{
The function `mz_vis` visualizes the mass difference distribution,
which has been summarized by `mz_summary`.
}
\details{
Plots the mass difference distribution, summarized
by `mz_summary`. 
Visualization is performed using ggplot2
}
\examples{
data("x_test", package = "MetNet")
transformation <- rbind(
    c("Monosaccharide (-H2O)", "C6H10O5", "162.0528234315"),
    c("Disaccharide (-H2O)", "C12H20O11", "340.1005614851"),
    c("Trisaccharide (-H2O)", "C18H30O15", "486.1584702945"))
transformation <- data.frame(group = transformation[, 1],
                                formula = transformation[, 2],
                                mass = as.numeric(transformation[, 3]))
am_struct <- structural(x_test, transformation, 
    var = c("group", "formula", "mass"), ppm = 5, directed = TRUE)
mz_sum <- mz_summary(am_struct, var = "group")
mz_vis(mz_sum)

}
\author{
Liesa Salzer, \email{liesa.salzer@helmholtz-muenchen.de} and
Thomas Naake, \email{thomasnaake@googlemail.com}
}
