% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{lasso}
\alias{lasso}
\title{Create an adjacency matrix based on LASSO}
\usage{
lasso(x, parallel = FALSE, ...)
}
\arguments{
\item{x}{matrix, where columns are the samples and the rows are features
(metabolites), cell entries are intensity values}

\item{parallel}{logical, should computation be parallelized? If
`parallel = TRUE` the `bplapply` will be applied if
`parallel = FALSE` the `lapply` function will be applied.}

\item{...}{parameters passed to `stabsel.matrix`}
}
\value{
matrix, matrix with edges inferred from LASSO algorithm
`stabsel.matrix`
}
\description{
`lasso` infers a adjacency matrix using
LASSO using the `stabsel.matrix` function from the
`stabs` package. `lasso` extracts the  predictors from the
function `stabsel.matrix` and writes the coefficients
to an adjacency matrix.
}
\details{
For use of the parameters used in the `stabsel.matrix` function,
refer to `?stabs::stabsel.matrix`.
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[1:10, 3:ncol(x_test)]
x <- as.matrix(x)
x_z <- t(apply(x, 1, function(y) (y - mean(y)) / sd(y)))
\dontrun{lasso(x = x_z, PFER = 0.95, cutoff = 0.95)}

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
