% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{getLinks}
\alias{getLinks}
\title{Write an adjacency matrix to a `data.frame`}
\usage{
getLinks(mat, exclude = "== 1", decreasing = TRUE)
}
\arguments{
\item{mat}{matrix containing the values of confidence for a link}

\item{exclude}{`character`, logical statement as `character` to set `TRUE`
values to NaN in `mat`, will be omitted if `exclude = NULL`}

\item{decreasing}{`logical`, if `TRUE`, the highest confidence value will 
get the first rank, if `FALSE`, the lowest confidence value will get the 
first rank}
}
\value{
`data.frame` with entries `row`, `col`, `confidence` and `rank`
}
\description{
`getLinks` vectorizes a numerical square `matrix` and writes the values
and their corresponding ranks to a `data.frame`.
}
\details{
`getLinks` is a helper function used in the function `threshold`.
}
\examples{
mat <- matrix(0:8, ncol = 3, nrow = 3)
MetNet:::getLinks(mat, exclude = "== 0", decreasing = TRUE)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
