% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcms_table_class.R
\name{lcms_table}
\alias{lcms_table}
\title{LCMS table}
\usage{
lcms_table(
  data = NULL,
  tag = "",
  id_column = "id",
  mz_column = "mz",
  rt_column = "rt",
  ...
)
}
\arguments{
\item{data}{(data.frame, NULL) A data.frame of annotation data. The
default is \code{NULL}.}

\item{tag}{(character) A (short) character string that is used to
represent this source e.g. in column names or source columns when
used in a workflow. The default is \code{""}.}

\item{id_column}{(character) The column name of the annotation
data.frame containing row identifers. If NULL This will be generated
automatically. The default is \code{"id"}.}

\item{mz_column}{(character) The column name of the annotation
data.frame containing m/z values. The default is \code{"mz"}.}

\item{rt_column}{(character) The column name of the annotation
data.frame containing retention time values. The default is
\code{"rt"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
lcms_table
} object. This object has no \code{output} slots.
}
\description{
An LCMS table extends \code{\link[=annotation_table]{annotation_table()}} to
represent annotation data for an LCMS experiment. Columns
representing m/z and retention time are required for an \code{lcms_table}.
}
\section{Inheritance}{

A \code{lcms_table} object inherits the following \code{struct} classes: \cr\cr
\verb{[lcms_table]} -> \verb{[annotation_table]} -> \verb{[annotation_source]} ->
\verb{[struct_class]}
}

\examples{
M <- lcms_table(
        mz_column = "mz",
        rt_column = "rt",
        id_column = "id",
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\concept{annotation_tables}
