% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutils_lookup_class.R
\name{eutils_lookup}
\alias{eutils_lookup}
\title{NCBI E-utils query}
\usage{
eutils_lookup(query_column, database, term, result_fields = "idlist", ...)
}
\arguments{
\item{query_column}{(character) The column name to use as the
reference for searching the database e.g. "HMBD_ID".}

\item{database}{(character) The name of the E-utils database to
search. See https://www.ncbi.nlm.nih.gov/books/NBK25501/ for details.}

\item{term}{(character) A correctly formated search term to use with
E-utils. See https://www.ncbi.nlm.nih.gov/books/NBK25501/ for
details. When used with the provided url template will automatically
include the value from the \code{query_column} at the beginning of the
term.}

\item{result_fields}{(character) The name of the search result field
to return. For E-utils this is often "idlist". The default is
\code{"idlist"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{eutils_lookup} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The annotation_source after
adding data returned by the API. \cr
}
}
\description{
Submit a query to one of the NCBI E-utils databases. See
https://www.ncbi.nlm.nih.gov/books/NBK25501/ for details.
}
\section{Inheritance}{

A \code{eutils_lookup} object inherits the following \code{struct} classes:
\cr\cr
\verb{[eutils_lookup]} -> \verb{[rest_api]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- eutils_lookup(
        database = "gene",
        term = "[pdat]",
        result_fields = "idlist",
        base_url = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils",
        url_template = "<base_url>/esearch.fcgi?db=<database>&term=<query_column><term>&retmode=json",
        query_column = character(0),
        cache = NULL,
        status_codes = list(),
        delay = 0.5,
        suffix = "_rest_api")

}
