% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_database_class.R
\name{annotation_database}
\alias{annotation_database}
\title{An annotation database}
\usage{
annotation_database(data = data.frame(), tag = "", ...)
}
\arguments{
\item{data}{(data.frame, NULL) A data.frame of annotation data. The
default is \code{data.frame()}.}

\item{tag}{(character) A (short) character string that is used to
represent this source e.g. in column names or source columns when
used in a workflow. The default is \code{""}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
annotation_database
} object. This object has no \code{output} slots.
}
\description{
An \code{annotation_database} is an \code{\link[=annotation_source]{annotation_source()}}
where the imported data.frame contains meta data for annotations. For
example it might be a table of molecular identifiers, associated
pathways etc.
}
\section{Inheritance}{

A \code{annotation_database} object inherits the following \code{struct}
classes: \cr\cr
\verb{[annotation_database]} -> \verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- annotation_database(
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\seealso{
Other annotation databases: 
\code{\link{AnnotationDb_database}},
\code{\link{GO_database}},
\code{\link{annotation_source}},
\code{\link{excel_database}},
\code{\link{rdata_database}},
\code{\link{rds_cache}},
\code{\link{rds_database}}

Other annotation sources: 
\code{\link{annotation_table}},
\code{\link{cd_source}},
\code{\link{ls_source}},
\code{\link{mspurity_source}}
}
\concept{annotation databases}
\concept{annotation sources}
