% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathScore.R
\name{mathScore}
\alias{mathScore}
\title{mathScore}
\usage{
mathScore(
  maf,
  patient.id = NULL,
  withinTumor = FALSE,
  min.vaf = 0,
  use.adjVAF = FALSE,
  segFile = NULL,
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{withinTumor}{Calculate between-region heterogeneity within tumor. Default: FALSE.}

\item{min.vaf}{Specify The minimum VAF to filter variants. Default: 0.}

\item{use.adjVAF}{Use adjusted VAF in analysis when adjusted VAF or CCF is available. Default: FALSE.}

\item{segFile}{The segment file.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). 
Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
A data.frame of MATH scores
}
\description{
calculates MATH score of each tumor sample or based on Mutant-Allele Tumor Heterogeneity (MATH) approach.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
mathScore(maf)

}
\references{
Mroz, Edmund A. et al. Intra-Tumor Genetic Heterogeneity and Mortality in Head and Neck Cancer: Analysis of Data from The Cancer Genome Atlas. Ed. Andrew H. Beck. PLoS Medicine 12.2 (2015): e1001786.
}
