% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{plotPCAVarPvalue}
\alias{plotPCAVarPvalue}
\title{Plot p-values for the significance of principal components}
\usage{
plotPCAVarPvalue(var_x, var_perm)
}
\arguments{
\item{var_x}{\code{numeric}, measured variances}

\item{var_perm}{\code{matrix}, variances obtained by permutation}
}
\value{
\code{gg} object from \code{ggplot}
}
\description{
The function \code{plotPCAVarPvalue} plots the p-values of significances of 
principal components. Using the visual output, the optimal number of 
principal components can be selected.
}
\details{
Internal usage in \code{shinyQC}.
}
\examples{
x <- matrix(seq_len(100), ncol = 10)
pca <- dimensionReduction(x = x, params = list(center = TRUE, scale = TRUE), 
    type = "PCA")[[2]]
var_x <- explVar(d = pca, type = "PCA")
var_perm <- permuteExplVar(x = x, n = 100, center = TRUE, scale = TRUE)
plotPCAVarPvalue(var_x = var_x, var_perm = var_perm)

}
\author{
Thomas Naake
}
