% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_measuredvalues_missingvalues.R
\name{histFeature}
\alias{histFeature}
\title{Histogram for measured value per feature}
\usage{
histFeature(x, measured = TRUE, ...)
}
\arguments{
\item{x}{\code{matrix} containing intensities. Missing values are encoded 
as \code{NA}.}

\item{measured}{\code{logical}, should the measured values 
(\code{measured = TRUE}) or missing values (\code{measured = FALSE}) be taken}

\item{...}{additional parameters passed to \code{geom_histogram}, e.g. 
\code{binwidth}.}
}
\value{
\code{plotly} object from \code{ggplotly}
}
\description{
The function \code{histFeature} creates a histogram with the number
of measured/missing values per feature.
}
\examples{
x <- matrix(c(c(1, 1, 1), c(1, NA, 1), c(1, NA, 1), 
    c(1, 1, 1), c(NA, 1, 1), c(NA, 1, 1)), byrow = FALSE, nrow = 3)
colnames(x) <- c("A_1", "A_2", "A_3", "B_1", "B_2", "B_3")
histFeature(x, binwidth = 1)

}
