% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{MAvalues}
\alias{MAvalues}
\title{Create values (M and A) for MA plot}
\usage{
MAvalues(se, log2 = TRUE, group = c("all", colnames(colData(se))))
}
\arguments{
\item{se}{\code{SummarizedExperiment}}

\item{log2}{\code{logical}, specifies if values are 
\code{log2}-transformed prior to calculating M and A values. 
If the values are already transformed, \code{log2} should be set to 
\code{FALSE}. If \code{log2 = TRUE} and if there are values in 
\code{assay(se)} that are 0, the \code{log2} values are calculated by
\code{log2(assay(se) + 1)}}

\item{group}{\code{character}, either \code{"all"} or one of 
\code{colnames(colData(se))}}
}
\value{
\code{tbl} with columns \code{Feature}, \code{name} (sample name), 
\code{A}, \code{M} and additional columns of \code{colData(se)}
}
\description{
The function \code{MAvalues} will create MA values as input for the function 
\code{MAplot} and \code{hoeffDValues}. 
\code{M} and \code{A} are specified relative to specified samples which 
is determined by the \code{group} argument. In case of \code{group == "all"}, 
all samples (expect the specified one) are taken for the reference 
calculation. In case of \code{group != "all"} will use the samples belonging 
to the same group given in \code{colnames(colData(se))} expect the 
specified one.
}
\examples{
## create se
set.seed(1)
a <- matrix(rnorm(10000), nrow = 1000, ncol = 10, 
            dimnames = list(seq_len(1000), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment(assay = a, rowData = rD, colData = cD)

MAvalues(se, log = FALSE, group = "all")

}
