% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{MAplot}
\alias{MAplot}
\title{Create a MA plot}
\usage{
MAplot(
  tbl,
  group = c("all", colnames(tbl)),
  plot = c("all", unique(tbl[["name"]]))
)
}
\arguments{
\item{tbl}{\code{tibble} containing the M and A values, as obtained from the 
\code{MAvalues} function}

\item{group}{\code{character}, one of \code{colnames(colData(se))} 
(\code{se} used in \code{MAvalues}) or \code{"all"}}

\item{plot}{\code{character}, one of \code{colData(se)$name} (\code{se} 
used in \code{MAvalues}) or \code{"all"}}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function creates a 2D histogram of M and A values.
}
\details{
\code{MAplot} returns a 2D hex histogram instead of a classical scatterplot 
due to computational reasons and better visualization of overlaying points.
The argument \code{plot} specifies the sample (refering to 
\code{colData(se)$name}) to be plotted. If \code{plot = "all"}, MA values 
for all samples will be plotted (samples will be plotted in facets). 
If the number of features (\code{tbl$Features}) is below 1000, points will be 
plotted (via \code{geom_points}), otherwise hexagons will be plotted
(via \code{geom_hex}).
}
\examples{
## create se
set.seed(1)
a <- matrix(rnorm(10000), nrow = 1000, ncol = 10,
            dimnames = list(seq_len(1000), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a,
    rowData = rD, colData = cD)

tbl <- MAvalues(se, log = FALSE, group = "all")
MAplot(tbl, group = "all", plot = "all")

}
