% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designSampleSize.R
\name{designSampleSize}
\alias{designSampleSize}
\title{Planning future experimental designs of Selected Reaction Monitoring (SRM), Data-Dependent Acquisition (DDA or shotgun), and Data-Independent Acquisition (DIA or SWATH-MS) experiments in sample size calculation}
\usage{
designSampleSize(
  data,
  desiredFC,
  FDR = 0.05,
  numSample = TRUE,
  power = 0.9,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{data}{'FittedModel' in testing output from function groupComparison.}

\item{desiredFC}{the range of a desired fold change which includes the lower 
and upper values of the desired fold change.}

\item{FDR}{a pre-specified false discovery ratio (FDR) to control the overall 
false positive rate. Default is 0.05}

\item{numSample}{minimal number of biological replicates per condition. 
TRUE represents you require to calculate the sample size for this category, 
else you should input the exact number of biological replicates.}

\item{power}{a pre-specified statistical power which defined as the probability 
of detecting a true fold change. TRUE represent you require to calculate the power 
for this category, else you should input the average of power you expect. Default is 0.9}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about 
data processing will be saved. 
If not provided, such a file will be created automatically.
If `append = TRUE`, has to be a valid path to a file.}
}
\value{
data.frame - sample size calculation results including varibles:
desiredFC, numSample, FDR,  and power.
}
\description{
Calculate sample size for future experiments of a Selected Reaction Monitoring (SRM), 
Data-Dependent Acquisition (DDA or shotgun), and Data-Independent Acquisition (DIA or SWATH-MS) experiment 
based on intensity-based linear model. Two options of the calculation: 
(1) number of biological replicates per condition, 
(2) power.
}
\details{
The function fits the model and uses variance components to calculate 
sample size. The underlying model fitting with intensity-based linear model with 
technical MS run replication. Estimated sample size is rounded to 0 decimal.
The function can only obtain either one of the categories of the sample size 
calculation (numSample, numPep, numTran, power) at the same time.
}
\examples{
# Consider quantitative data (i.e. QuantData) from yeast study.
# A time course study with ten time points of interests and three biological replicates.
QuantData <- dataProcess(SRMRawData)
head(QuantData$FeatureLevelData)
## based on multiple comparisons  (T1 vs T3; T1 vs T7; T1 vs T9)
comparison1<-matrix(c(-1,0,1,0,0,0,0,0,0,0),nrow=1)
comparison2<-matrix(c(-1,0,0,0,0,0,1,0,0,0),nrow=1)
comparison3<-matrix(c(-1,0,0,0,0,0,0,0,1,0),nrow=1)
comparison<-rbind(comparison1,comparison2, comparison3)
row.names(comparison)<-c("T3-T1","T7-T1","T9-T1")
colnames(comparison)<-unique(QuantData$ProteinLevelData$GROUP)

testResultMultiComparisons<-groupComparison(contrast.matrix=comparison,data=QuantData)

## Calculate sample size for future experiments:
#(1) Minimal number of biological replicates per condition
designSampleSize(data=testResultMultiComparisons$FittedModel, numSample=TRUE,
                 desiredFC=c(1.25,1.75), FDR=0.05, power=0.8)
#(2) Power calculation
designSampleSize(data=testResultMultiComparisons$FittedModel, numSample=2,
                 desiredFC=c(1.25,1.75), FDR=0.05, power=TRUE)
                 
}
\author{
Meena Choi, Ching-Yun Chang, Olga Vitek.
}
