% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_summarization_checks.R
\name{.checkSummarizationParams}
\alias{.checkSummarizationParams}
\title{Check validity of parameters to proteinSummarization function}
\usage{
.checkSummarizationParams(
  data,
  method,
  global_norm,
  reference_norm,
  remove_norm_channel,
  remove_empty_channel,
  MBimpute,
  maxQuantileforCensored
)
}
\arguments{
\item{data}{Name of the output of PDtoMSstatsTMTFormat function or peptide-level quantified data from other tools. 
It should have columns ProteinName, PeptideSequence, Charge, PSM, Mixture, TechRepMixture, Run, Channel, Condition, BioReplicate, Intensity}

\item{method}{Four different summarization methods to protein-level can be performed : "msstats"(default), "MedianPolish", "Median", "LogSum".}

\item{global_norm}{Global median normalization on peptide level data (equalizing the medians across all the channels and MS runs). Default is TRUE. 
It will be performed before protein-level summarization.}

\item{reference_norm}{Reference channel based normalization between MS runs on protein level data. 
TRUE(default) needs at least one reference channel in each MS run, annotated by 'Norm' in Condtion column. 
It will be performed after protein-level summarization. FALSE will not perform this normalization step. 
If data only has one run, then reference_norm=FALSE.}

\item{remove_norm_channel}{TRUE(default) removes 'Norm' channels from protein level data.}

\item{remove_empty_channel}{TRUE(default) removes 'Empty' channels from protein level data.}

\item{MBimpute}{only for method="msstats". TRUE (default) imputes missing values by Accelated failure model. 
FALSE uses minimum value to impute the missing value for each peptide precursor ion.}

\item{maxQuantileforCensored}{We assume missing values are censored. 
maxQuantileforCensored is Maximum quantile for deciding censored missing value, for instance, 0.999. Default is Null.}
}
\value{
TRUE invisibly if all parameters are valid
}
\description{
Check validity of parameters to proteinSummarization function
}
\keyword{internal}
