% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonPTM.R
\name{groupComparisonPTM}
\alias{groupComparisonPTM}
\title{Perform differential analysis on MS-based proteomics experiments targeting PTMs}
\usage{
groupComparisonPTM(
  data,
  data.type = NULL,
  contrast.matrix = "pairwise",
  moderated = FALSE,
  adj.method = "BH",
  log_base = 2,
  save_fitted_models = TRUE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstatsPTM_log_",
  ptm_label_type = "LF",
  protein_label_type = "LF"
)
}
\arguments{
\item{data}{list of summarized datasets. Output of MSstatsPTM summarization
function \code{\link[MSstatsPTM]{dataSummarizationPTM}}  or
\code{\link[MSstatsPTM]{dataSummarizationPTM_TMT}} depending on acquisition
type.}

\item{data.type}{Type of data. Must be one of \code{LF} or \code{TMT}. Will be deprecated
in favor of ptm_label_type and protein_label_type.}

\item{contrast.matrix}{comparison between conditions of interests. Default
models full pairwise comparison between all conditions}

\item{moderated}{For TMT experiments only. TRUE will moderate t statistic;
FALSE (default) uses ordinary t statistic. Default is FALSE.}

\item{adj.method}{For TMT experiments only. Adjusted method for multiple
comparison. "BH" is default. "BH" is used for all other experiment types}

\item{log_base}{For non-TMT experiments only. The base of the logarithm used
in summarization.}

\item{save_fitted_models}{logical, if TRUE, fitted models will be added to
the output.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}

\item{ptm_label_type}{Indicator of labeling type for PTM dataset. Must be one
of \code{LF} or \code{TMT}}

\item{protein_label_type}{Indicator of labeling type for PROTEIN dataset.
Must be one of \code{LF} or \code{TMT}}
}
\value{
list of modeling results. Includes PTM, PROTEIN, and ADJUSTED
data.tables with their corresponding model results.
}
\description{
Takes summarized PTM and protein data from \code{dataSummarizationPTM} or
\code{dataSummarizationPTM_TMT} functions and performs differential analysis.
Leverages unmodified protein data to perform adjustment and deconvolute the
effect of the PTM and unmodified protein. If protein data is unavailable,
PTM data can still be passed into the function, however adjustment can not be
performed. All model results are returned for completeness.
}
\examples{

model.lf.msstatsptm = groupComparisonPTM(summary.data, 
                                     ptm_label_type="LF",
                                     protein_label_type="LF",
                                     verbose = FALSE)
}
