% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_logging.R
\name{MSstatsLogsSettings}
\alias{MSstatsLogsSettings}
\title{Set how MSstats will log information from data processing}
\usage{
MSstatsLogsSettings(
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstats_log_",
  pkg_name = "MSstats"
)
}
\arguments{
\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}

\item{pkg_name}{currently "MSstats", "MSstatsPTM" or "MSstatsTMT".
Each package can use its own separate log settings.}
}
\value{
TRUE invisibly in case of successful logging setup.
}
\description{
Set how MSstats will log information from data processing
}
\examples{
# No logging and no messages
MSstatsLogsSettings(FALSE, FALSE, FALSE)
# Log, but do not display messages
MSstatsLogsSettings(TRUE, FALSE, FALSE)
# Log to an existing file
file.create("new_log.log")
MSstatsLogsSettings(TRUE, TRUE, log_file_path = "new_log.log")
# Do not log, but display messages
MSstatsLogsSettings(FALSE)

}
