#' MSstatsConvert: An R Package to Convert Data from Mass Spectrometry Signal Processing Tools to MSstats Format
#'
#' MSstatsConvert helps convert data from different types of mass spectrometry experiments and
#' signal processing tools to a format suitable for statistical analysis with the MSstats and MSstatsTMT packages.
#'
#' @section Main functions:
#' \code{\link{MSstatsLogsSettings}} for logs management,
#' \code{\link{MSstatsImport}} for importing files created by signal processing tools,
#' \code{\link{MSstatsClean}} for re-formatting imported files into a consistent format,
#' \code{\link{MSstatsPreprocess}} for preprocessing cleaned files,
#' \code{\link{MSstatsBalancedDesign}} for handling fractions and creating balanced data.
#'
#' @import data.table
#' @name MSstatsConvert
#' @keywords internal
"_PACKAGE"
