% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateProteinInfoFromIndra.R
\name{annotateProteinInfoFromIndra}
\alias{annotateProteinInfoFromIndra}
\title{Annotate Protein Information from Indra}
\usage{
annotateProteinInfoFromIndra(df, proteinIdType)
}
\arguments{
\item{df}{output of \code{\link[MSstats]{groupComparison}} function's 
comparisonResult table, which contains a list of proteins and their 
corresponding p-values, logFCs, along with additional HGNC ID and HGNC 
name columns}

\item{proteinIdType}{A character string specifying the type of protein ID. 
It can be either "Uniprot" or "Uniprot_Mnemonic".}
}
\value{
A data frame with the following columns:
\describe{
  \item{Protein}{Character. The original protein identifier.}
  \item{UniprotID}{Character. The Uniprot ID of the protein.}
  \item{HgncID}{Character. The HGNC ID of the protein.}
  \item{HgncName}{Character. The HGNC name of the protein.}
  \item{IsTranscriptionFactor}{Logical. Indicates if the protein is a transcription factor.}
  \item{IsKinase}{Logical. Indicates if the protein is a kinase.}
  \item{IsPhosphatase}{Logical. Indicates if the protein is a phosphatase.}
}
}
\description{
This function annotates a data frame with protein information from Indra.
}
\examples{
df <- data.frame(Protein = c("CLH1_HUMAN"))
annotated_df <- annotateProteinInfoFromIndra(df, "Uniprot_Mnemonic")
head(annotated_df)
}
