% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readChromData.R
\name{readSRMData}
\alias{readSRMData}
\title{Read SRM/MRM chromatographic data}
\usage{
readSRMData(files, pdata = NULL)
}
\arguments{
\item{files}{\code{character} with the files containing the SRM/MRM data.}

\item{pdata}{\code{data.frame} or \code{AnnotatedDataFrame} with file/sample
descriptions.}
}
\value{
A \code{MChromatograms()} object. See details above for more information.
}
\description{
The \code{readSRMData} function reads MRM/SRM data from provided \emph{mzML} files and
returns the results as a \code{\link[=MChromatograms]{MChromatograms()}} object.
}
\details{
\code{readSRMData} supports reading chromatogram entries from \emph{mzML} files. If
multiple files are provided the same precursor and product m/z for SRM/MRM
chromatograms are expected across files. The number of columns of the
resulting \code{\link[=MChromatograms]{MChromatograms()}} object corresponds to the number of files. Each
row in the \code{MChromatograms} object is supposed to contain chromatograms
with same polarity, precursor and product m/z. If chromatograms with
redundant polarity, precursor and product m/z values and precursor collision
energies are found, they are placed into multiple consecutive rows in the
\code{MChromatograms} object.
}
\note{
\code{readSRMData} reads only SRM/MRM chromatogram data, i.e. chromatogram data
from mzML files with \code{precursorIsolationWindowTargetMZ} and
\code{productIsolationWindowTargetMZ} attributes. Total ion chromatogram data is
hence not extracted.

The number of features and hence rows of the resulting \code{MChromatograms}
object depends on the total list of unique precursor and product m/z
isolation windows (and precursor collision energies) found across all input
files. In cases in which not each file has chromatgraphic data for the same
polarity, precursor m/z, product m/z and collision energy,
an empty \code{Chromatogram()} object is reported for the specific precursor
and product m/z combination of the respective file (and a warning is
thrown).
}
\examples{

## Read an example MRM/SRM data
library(msdata)
fl <- proteomics(full.names = TRUE, pattern = "MRM")

## Read the data
mrm <- readSRMData(fl)

## The data is represented as a MChromatograms object, each column
## containing the data from one input file
mrm

## Access the polarity for each chromatogram (row)
polarity(mrm)

## Access the precursor m/z. The result is returned as a matrix with
## columns representing the minimum and maximum m/z (will be identical in
## most cases).
precursorMz(mrm)

## Access the product m/z.
productMz(mrm)

## Plot one chromatogram
plot(mrm[1, ])
}
\author{
Johannes Rainer
}
