% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing-data.R
\name{imageNA2}
\alias{imageNA2}
\title{NA heatmap visualisation for 2 groups}
\usage{
imageNA2(
  object,
  pcol,
  Rowv,
  Colv = TRUE,
  useGroupMean = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class MSnSet}

\item{pcol}{Either the name of a phenoData variable to be used to
determine the group structure or a factor or any object that can
be coerced as a factor of length equal to nrow(object). The
resulting factor must have 2 levels. If missing (default)
\code{image(object)} is called.}

\item{Rowv}{Determines if and how the rows/features are
reordered. If missing (default), rows are reordered according to
\code{order((nNA1 + 1)^2/(nNA2 + 1))}, where NA1 and NA2 are the
number of missing values in each group. Use a vector of numerics
of feautre names to customise row order.}

\item{Colv}{A \code{logical} that determines if columns/samples
are reordered. Default is \code{TRUE}.}

\item{useGroupMean}{Replace individual feature intensities by the
group mean intensity. Default is FALSE.}

\item{plot}{A \code{logical} specifying of an image should be
produced. Default is \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link{image}}.}
}
\value{
Used for its side effect of plotting. Invisibly returns
Rovw and Colv.
}
\description{
Produces a heatmap after reordring rows and columsn to highlight
missing value patterns.
}
\examples{
library("pRolocdata")
library("pRoloc")
data(dunkley2006)
pcol <- ifelse(dunkley2006$fraction <= 5, "A", "B")
nax <- makeNaData(dunkley2006, pNA = 0.10)
exprs(nax)[sample(nrow(nax), 30), pcol == "A"] <- NA
exprs(nax)[sample(nrow(nax), 50), pcol == "B"] <- NA
MSnbase:::imageNA2(nax, pcol)
MSnbase:::imageNA2(nax, pcol, useGroupMean = TRUE)
MSnbase:::imageNA2(nax, pcol, Colv = FALSE, useGroupMean = FALSE)
MSnbase:::imageNA2(nax, pcol, Colv = FALSE, useGroupMean = TRUE)
}
\author{
Laurent Gatto, Samuel Wieczorek and Thomas Burger
}
