% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iPQF.R
\name{iPQF}
\alias{iPQF}
\title{iPQF: iTRAQ (and TMT) Protein Quantification based on
Features}
\usage{
iPQF(
  object,
  groupBy,
  low.support.filter = FALSE,
  ratio.calc = "sum",
  method.combine = FALSE,
  feature.weight = c(7, 6, 4, 3, 2, 1, 5)^2
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet} containing
absolute ion intensities.}

\item{groupBy}{Vector defining spectra to protein
matching. Generally, this is a feature variable such as
\code{fData(object)$accession}.}

\item{low.support.filter}{A \code{logical} specifying if proteins
being supported by only 1-2 peptide spectra should be filtered
out. Default is \code{FALSE}.}

\item{ratio.calc}{Either \code{"none"} (don't calculate any
ratios), \code{"sum"} (default), or a specific channel (one of
\code{sampleNames(object)}) defining how to calculate relative
peptides intensities.}

\item{method.combine}{A \code{logical} defining whether to further
use median polish to combine features.}

\item{feature.weight}{Vector \code{"numeric"} giving weight to the
different features. Default is the squared order of the
features redundant -unique-distance metric, charge state, ion
intensity, sequence length, identification score, modification
state, and mass based on a robustness analysis.}
}
\value{
A \code{matrix} with estimated protein ratios.
}
\description{
The iPQF spectra-to-protein summarisation method integrates
peptide spectra characteristics and quantitative values for protein
quantitation estimation. Spectra features, such as charge state,
sequence length, identification score and others, contain valuable
information concerning quantification accuracy. The iPQF algorithm
assigns weights to spectra according to their overall feature reliability
and computes a weighted mean to estimate protein quantities.
See also \code{\link{combineFeatures}} for a more
general overview of feature aggregation and examples.
}
\examples{
data(msnset2)
head(exprs(msnset2))
prot <- combineFeatures(msnset2,
                        groupBy = fData(msnset2)$accession,
                        method = "iPQF")
head(exprs(prot))
}
\references{
iPQF: a new peptide-to-protein summarization method
using peptide spectra characteristics to improve protein
quantification. Fischer M, Renard BY.  Bioinformatics. 2016
Apr 1;32(7):1040-7. doi:10.1093/bioinformatics/btv675. Epub
2015 Nov 20. PubMed PMID:26589272.
}
\author{
Martina Fischer
}
