% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData-utils.R
\name{expandFeatureVars}
\alias{expandFeatureVars}
\alias{mergeFeatureVars}
\title{Expand or merge feature variables}
\usage{
expandFeatureVars(x, fcol, prefix)

mergeFeatureVars(x, fcol, fcol2)
}
\arguments{
\item{x}{An object of class \code{MSnSet}.}

\item{fcol}{A \code{character()} of feature variables to expand (for
\code{expandFeatureVars}) or merge (for \code{mergeFeatureVars}).}

\item{prefix}{A \code{character(1)} to use as prefix to the new feature
variables. If missing (default), then \code{fcol} is used
instead. If \code{NULL}, then no prefix is used.}

\item{fcol2}{A \code{character(1)} defining the name of the new feature
variable.}
}
\value{
An \code{MSnSet} for expanded (merged) feature variables.
}
\description{
The \code{expandFeatureVars} and \code{mergeFeatureVars} respectively expand
and merge groups of feature variables. Using these functions, a
set of columns in a feature data can be merged into a single new
data.frame-column variables and a data.frame-column can be
expanded into single feature columns. The original feature
variables are removed.
}
\examples{
library("pRolocdata")
data(hyperLOPIT2015)
fvarLabels(hyperLOPIT2015)
## Let's merge all svm prediction feature variables
(k <- grep("^svm", fvarLabels(hyperLOPIT2015), value = TRUE))
hl <- mergeFeatureVars(hyperLOPIT2015, fcol = k, fcol2 = "SVM")
fvarLabels(hl)
head(fData(hl)$SVM)

## Let's expand the new SVM into individual columns
hl2 <- expandFeatureVars(hl, "SVM")
fvarLabels(hl2)
## We can set the prefix manually
hl2 <- expandFeatureVars(hl, "SVM", prefix = "Expanded")
fvarLabels(hl2)
## If we don't want any prefix
hl2 <- expandFeatureVars(hl, "SVM", prefix = NULL)
fvarLabels(hl2)
}
\author{
Laurent Gatto
}
