% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-MSnExp.R, R/methods-MSpectra.R
\name{combineSpectra,MSnExp-method}
\alias{combineSpectra,MSnExp-method}
\alias{combineSpectra,MSpectra-method}
\alias{combineSpectra}
\title{Combine Spectra}
\usage{
\S4method{combineSpectra}{MSnExp}(
  object,
  fcol = "fileIdx",
  method = meanMzInts,
  ...,
  BPPARAM = bpparam()
)

\S4method{combineSpectra}{MSpectra}(object, fcol, method = meanMzInts, fun, ...)
}
\arguments{
\item{object}{A \linkS4class{MSnExp} or \linkS4class{MSpectra}}

\item{fcol}{For \code{MSpectra} objects: \code{mcols} column name to be used to define
the sets of spectra to be combined. If missing, all spectra are
considered to be one set. For \code{MSnExp}/\code{OnDiskMSnExp} objects: column
in \code{fData(object)} defining which spectra to combine. See examples below
for more details.}

\item{method}{\code{function} to be used to combine the spectra by \code{fcol}. Has to
be a function that takes a list of spectra as input and returns a single
\linkS4class{Spectrum}. See \code{\link[=meanMzInts]{meanMzInts()}} for details.}

\item{...}{additional arguments for \code{fun}.}

\item{BPPARAM}{For \code{MSnExp}/\code{OnDiskMSnExp} objects: parallel processing setup
to perform per-file parallel spectra combining. See \code{\link[=bpparam]{bpparam()}} for more
details.}

\item{fun}{\emph{Deprecated} use \code{method} instead.}
}
\value{
A \code{MSpectra} or \code{MSnExp} object with combined spectra. Metadata
(\code{mcols}) and all spectrum attributes other than \code{mz} and \code{intensity}
are taken from the first \code{Spectrum} in each set.
}
\description{
\code{combineSpectra} combines spectra in a \linkS4class{MSnExp}, \linkS4class{OnDiskMSnExp}
or \linkS4class{MSpectra} object applying the summarization function \code{fun} to sets
of spectra defined by a factor (\code{fcol} parameter). The resulting combined
spectrum for each set contains metadata information (present in \code{mcols} and
all spectrum information other than \code{mz} and \code{intensity}) from the \strong{first}
spectrum in each set.

Combining of spectra for \linkS4class{MSnExp} or \linkS4class{OnDiskMSnExp} objects is
performed by default for each file \strong{separately}, combining of spectra
across files is thus not possible. See examples for details.
}
\examples{

set.seed(123)
mzs <- seq(1, 20, 0.1)
ints1 <- abs(rnorm(length(mzs), 10))
ints1[11:20] <- c(15, 30, 90, 200, 500, 300, 100, 70, 40, 20) # add peak
ints2 <- abs(rnorm(length(mzs), 10))
ints2[11:20] <- c(15, 30, 60, 120, 300, 200, 90, 60, 30, 23)
ints3 <- abs(rnorm(length(mzs), 10))
ints3[11:20] <- c(13, 20, 50, 100, 200, 100, 80, 40, 30, 20)

## Create the spectra.
sp1 <- new("Spectrum1", mz = mzs + rnorm(length(mzs), sd = 0.01),
    intensity = ints1, rt = 1)
sp2 <- new("Spectrum1", mz = mzs + rnorm(length(mzs), sd = 0.01),
    intensity = ints2, rt = 2)
sp3 <- new("Spectrum1", mz = mzs + rnorm(length(mzs), sd = 0.009),
    intensity = ints3, rt = 3)

spctra <- MSpectra(sp1, sp2, sp3,
    elementMetadata = DataFrame(idx = 1:3, group = c("b", "a", "a")))

## Combine the spectra reporting the maximym signal
res <- combineSpectra(spctra, mzd = 0.05, intensityFun = max)
res

## All values other than m/z and intensity are kept from the first spectrum
rtime(res)

## Plot the individual and the merged spectrum
par(mfrow = c(2, 1), mar = c(4.3, 4, 1, 1))
plot(mz(sp1), intensity(sp1), xlim = range(mzs[5:25]), type = "h", col = "red")
points(mz(sp2), intensity(sp2), type = "h", col = "green")
points(mz(sp3), intensity(sp3), type = "h", col = "blue")
plot(mz(res[[1]]), intensity(res[[1]]), type = "h",
    col = "black", xlim = range(mzs[5:25]))

## Combine spectra in two sets.
res <- combineSpectra(spctra, fcol = "group", mzd = 0.05)
res

rtime(res)

## Plot the individual and the merged spectra
par(mfrow = c(3, 1), mar = c(4.3, 4, 1, 1))
plot(mz(sp1), intensity(sp1), xlim = range(mzs[5:25]), type = "h", col = "red")
points(mz(sp2), intensity(sp2), type = "h", col = "green")
points(mz(sp3), intensity(sp3), type = "h", col = "blue")
plot(mz(res[[1]]), intensity(res[[1]]), xlim = range(mzs[5:25]), type = "h",
    col = "black")
plot(mz(res[[2]]), intensity(res[[2]]), xlim = range(mzs[5:25]), type = "h",
    col = "black")

## Combining spectra of an MSnExp/OnDiskMSnExp objects
## Reading data from 2 mzML files
sciex <- readMSData(dir(system.file("sciex", package = "msdata"),
    full.names = TRUE), mode = "onDisk")

## Filter the file to a retention time range from 2 to 20 seconds (to reduce
## execution time of the example)
sciex <- filterRt(sciex, rt = c(2, 20))
table(fromFile(sciex))

## We have thus 64 spectra per file.

## In the example below we combine spectra measured in one second to a
## single spectrum. We thus first define the grouping variable and add that
## to the `fData` of the object. For combining, we use the
## `consensusSpectrum` function that combines the spectra keeping only peaks
## that were found in 50\% of the spectra; by defining `mzd = 0.01` all peaks
## within an m/z of 0.01 are evaluated for combining.
seconds <- round(rtime(sciex))
head(seconds)
fData(sciex)$second <- seconds

res <- combineSpectra(sciex, fcol = "second", mzd = 0.01, minProp = 0.1,
    method = consensusSpectrum)
table(fromFile(res))

## The data was reduced to 19 spectra for each file.
}
\seealso{
\code{\link[=meanMzInts]{meanMzInts()}} for a function to combine spectra.
}
\author{
Johannes Rainer, Laurent Gatto
}
