% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTesting.R
\name{testLrt}
\alias{testLrt}
\title{Calculate likelihood ratio test for the specific nested model}
\usage{
testLrt(obj)
}
\arguments{
\item{obj}{the MpraObject containing the full and reduced}
}
\value{
results data frame
}
\description{
Calculate likelihood ratio test for the specific nested model
}
\note{
Must be run after running an LRT-based analysis
}
\examples{
data <- simulateMPRA(tr = rep(2,5), da=c(rep(0,2), rep(1,3)), 
                     nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- analyzeComparative(obj, dnaDesign = ~ batch + barcode + condition, 
                              rnaDesign = ~ condition, reducedDesign = ~ 1)
results <- testLrt(obj)
}
