% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessFunctions.R
\name{getDistrParam_DNA}
\alias{getDistrParam_DNA}
\alias{getDistrParam_RNA}
\title{Get model distribution parameters from an MpraObject of a given candidate 
enhancer}
\usage{
getDistrParam_DNA(obj, enhancer, full = TRUE)

getDistrParam_RNA(obj, enhancer = NULL, full = TRUE)
}
\arguments{
\item{obj}{MpraObject to extract from}

\item{enhancer}{enhancer to extract}

\item{full}{whether to extract from full model}
}
\value{
fit parameters (numeric, samples x parameters)
}
\description{
Get model distribution parameters from an MpraObject of a given candidate 
enhancer
}
\examples{
data <- simulateMPRA(tr = rep(2,5), nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- analyzeQuantification(obj, dnaDesign = ~ batch + barcode, 
                              rnaDesign = ~1)
## get distributional parameters of the first enhancer:
dist.params.dna <- getDistrParam_DNA(obj, 1)
dist.params.rna <- getDistrParam_RNA(obj, 1)

}
