% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamplingFunctions.R
\name{resamplingModulesSurvival}
\alias{resamplingModulesSurvival}
\alias{resamplingPathwaySurvival}
\title{Resampling function for survival analysis on modules}
\usage{
resamplingModulesSurvival(
  fullMultiOmics,
  pathdb,
  nperm = 100,
  pathwaySubset = NULL,
  nPatients = 3,
  genesToConsider = NULL
)

resamplingPathwaySurvival(
  fullMultiOmics,
  pathdb,
  nperm = 100,
  pathwaySubset = NULL,
  nPatients = 3,
  genesToConsider = NULL
)
}
\arguments{
\item{fullMultiOmics}{a multiOmic object}

\item{pathdb}{pathway database}

\item{nperm}{number of permutations}

\item{pathwaySubset}{a list of pathways to resample}

\item{nPatients}{number of patients to remove for resampling}

\item{genesToConsider}{vector of genes used to filter pathways; if NULL,
genes found in the first experiment of the multiOmic object are used}
}
\value{
list of the resampling tables of results

list of the resampling tables of results
}
\description{
Resampling function for survival analysis on modules

Resampling function for pathways (survival analysis)
}
\examples{
data(multiOmics)
data(reactSmall)

perms <- resamplingModulesSurvival(
    fullMultiOmics = multiOmics, reactSmall,
    nperm = 10,
    pathwaySubset =
        "FGFR1 mutant receptor activation"
)

}
