% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diggit.r
\name{associateEvents}
\alias{associateEvents}
\title{Use 'aREA' to calculate the enrichment between each genomic event - 
VIPER inferred protein pair.}
\usage{
associateEvents(
  vipermat,
  events.mat,
  min.events = NA,
  whitelist = NA,
  event.type = c("Amplifications", "Deletions", "Mutations", "Fusions", NA),
  verbose
)
}
\arguments{
\item{vipermat}{Pre-computed VIPER scores with samples as columns and proteins
as rows}

\item{events.mat}{Binary 0/1 events matrix with samples as columns and genes 
or events as rows}

\item{min.events}{Only compute enrichment if the number of samples with these
events is GTE to this}

\item{whitelist}{Only compute associations for events in this list}

\item{event.type}{Name of the event type being analyzed}

\item{verbose}{whether to print extra progress statements}
}
\value{
A matrix of aREA scores, dimensions are nrow(events.mat) x nrow(vipermat)
}
\description{
Requires pre-computed VIPER scores and a binary events matrix. Will use only 
samples in both event and VIPER matrices.
}
\keyword{internal}
