% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{PartitionModularity}
\alias{PartitionModularity}
\title{Illustration of modularity density}
\usage{
PartitionModularity(ADJ, PartitionSet)
}
\arguments{
\item{ADJ}{gene similarity matrix}

\item{PartitionSet}{vector indicates the partition label for genes}
}
\value{
partition modularity, defined as average modularity of all modules
}
\description{
Calculate the average modularity of a partition. The modularity of each 
module is defined from a natural generalization of unweighted case.
}
\examples{
data(synthetic)
ADJ1=abs(cor(datExpr1,use="p"))^10
dissADJ=1-ADJ1
hierADJ=hclust(as.dist(dissADJ), method="average" )
groups <- cutree(hierADJ, h = 0.8)
pDensity <- PartitionModularity(ADJ1,groups) 

}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Newman, Mark EJ. "Analysis of weighted networks." Physical 
review E 70.5 (2004): 056131.
}
\keyword{modularity}

