% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{CompareAllNets}
\alias{CompareAllNets}
\title{Illustration of network comparison}
\usage{
CompareAllNets(ResultFolder, intModules, indicator, intconditionModules,
  conditionNames, specificTheta, conservedTheta)
}
\arguments{
\item{ResultFolder}{where to store results}

\item{intModules}{how many modules in the background network}

\item{indicator}{identifier of current profile, served as a tag in name}

\item{intconditionModules}{a numeric vector, each of them is the number 
of modules in each condition-specific network. Or just single number}

\item{conditionNames}{a character vector, each of them is the name 
of condition. Or just single name}

\item{specificTheta}{the threshold to define min(s)+specificTheta, 
less than which is considered as condition specific module. 
s is the sums of rows in Jaccard index matrix. See supplementary file.}

\item{conservedTheta}{The threshold to define max(s)-conservedTheta, 
greater than which is considered as condition conserved module. 
s is the sums of rows in Jaccard index matrix. See supplementary file.}
}
\value{
None
}
\description{
Compare the background network and a set of condition-specific network. 
Conserved or condition-specific modules are indicated by the plain files, 
based on the statistics
}
\examples{
data(synthetic)
ResultFolder = 'ForSynthetic' # where middle files are stored
CuttingCriterion = 'Density' # could be Density or Modularity
indicator1 = 'X'     # indicator for data profile 1
indicator2 = 'Y'      # indicator for data profile 2
specificTheta = 0.1 #threshold to define condition specific modules
conservedTheta = 0.1#threshold to define conserved modules
intModules1 <- WeightedModulePartitionHierarchical(datExpr1,ResultFolder,
indicator1,CuttingCriterion) 
intModules2 <- WeightedModulePartitionHierarchical(datExpr2,ResultFolder,
indicator2,CuttingCriterion) 
CompareAllNets(ResultFolder,intModules1,indicator1,intModules2,indicator2,
specificTheta,conservedTheta)

}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\seealso{
\code{\link{WeightedModulePartitionHierarchical}},
\code{\link{comparemodulestwonets}}
}
\keyword{differential}
\keyword{module}

