% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{loadExamples}
\alias{loadExamples}
\title{Load example MIRit objects}
\usage{
loadExamples(class = "MirnaExperiment")
}
\arguments{
\item{class}{It must be \code{MirnaExperiment} (default) to load an example
object of class \code{\link[=MirnaExperiment-class]{MirnaExperiment}},
\code{IntegrativePathwayAnalysis}, to load an example object of class
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}}, or
\code{FunctionalEnrichment}, to load an example object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}}.}
}
\value{
An example \code{MirnaExperiment} object, an \code{IntegrativePathwayAnalysis}
object, or a \code{FunctionalEnrichment} object.
}
\description{
This helper function allows to create a
\code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing miRNA and gene
expression data deriving from Riesco-Eizaguirre et al (2015), an
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}} object
containing TAIPA results for the same dataset, or a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} with example GSEA
enrichment results.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# load example IntegrativePathwayAnalysis object
obj <- loadExamples("IntegrativePathwayAnalysis")

# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
